//@doc      CONFWM HDR CORE
//@module   CONFWM.H - Public Windows/MFC configuration header |
//
//  This is the simplified header (Windows/MFC only) for use with MetaKit.
//
//  There is no point in exporting the bulky and complex conditional header
//  structure used within the library itself, but the definitions below will
//  have to be changed substantially to support other platforms, etc.
//  
//@normal   Copyright <cp> 1996 Meta Four Software. All rights reserved.

#ifndef __K4CONF_H__
#define __K4CONF_H__

/////////////////////////////////////////////////////////////////////////////
// Microsoft Foundation Classes

#include <afxcoll.h>

typedef class CFile			c4_File;
typedef class CString       c4_String;
typedef class CPtrArray     c4_PtrArray;

/////////////////////////////////////////////////////////////////////////////

    // by default, if MFC is linked as a DLL, then so is MetaKit
#if defined (_AFXDLL) && !defined (q4_KITDLL)
	#define q4_KITDLL _AFXDLL
#endif

#if _MSC_VER == 800
	    // MSVC 1.52 thinks typedef has no constructor, use a macro instead
    #define c4_String CString
		// MSVC 1.52 only works if expanding inline in release builds (why?)
	#if NDEBUG && !defined (q4_INLINE)
		#define q4_INLINE 1 
	#endif
#endif

	// MSVC 4.x can specify the library it needs to link here
#if _MSC_VER >= 1000
	#if q4_KITDLL
		#ifdef _DEBUG
			#pragma comment(lib, "mk4nvmxd.lib")
		#else
			#pragma comment(lib, "mk4nvmx.lib")
		#endif
	#else
		#ifdef _DEBUG
			#pragma comment(lib, "mk4nvmsd.lib")
		#else
			#pragma comment(lib, "mk4nvms.lib")
		#endif
	#endif
#endif

/////////////////////////////////////////////////////////////////////////////
// Other definitions needed by the public MetaKit library header files

#if q4_INLINE                           // enable inline expansion
    #define d4_inline inline
#else
    #define d4_inline
#endif

#define false 0
#define true 1
#define bool int

typedef unsigned char   uchar;
typedef unsigned short  ushort;
typedef unsigned int    uint;
typedef unsigned long   ulong;
    
/////////////////////////////////////////////////////////////////////////////

#endif
